"""Search providers for torrent sources."""

from .base import SearchProvider, SearchProviderInfo, SearchProviderSafetyStatus
from .thepiratebay import ThePirateBayProvider
from .nyaa import NyaaProvider
from .leet import LeetProvider
from .torrents_csv import TorrentsCSVProvider
from .yts import YtsProvider
from .eztv import EztvProvider
from .additional import (
    AnimeToshoProvider,
    KnabenProvider,
    LimeTorrentsProvider,
    MyPornClubProvider,
    SukebeiProvider,
    TheRarBgProvider,
    TokyoToshokanProvider,
    TorrentDownloadsProvider,
    UlndexProvider,
    XXXClubProvider,
)

__all__ = [
    'SearchProvider',
    'SearchProviderInfo',
    'SearchProviderSafetyStatus',
    'ThePirateBayProvider',
    'NyaaProvider',
    'LeetProvider',
    'TorrentsCSVProvider',
    'YtsProvider',
    'EztvProvider',
]


def get_all_providers():
    """Get all available search providers."""
    return [
        # All websites (general content)
        TorrentsCSVProvider(),  # All
        LeetProvider(),  # 1337x - All
        ThePirateBayProvider(),  # All - Unsafe
        KnabenProvider(),  # All
        LimeTorrentsProvider(),  # All - Unsafe
        TheRarBgProvider(),  # All - Unsafe
        TorrentDownloadsProvider(),  # All
        UlndexProvider(),  # All
        
        # Movies
        YtsProvider(),  # Movies
        
        # Anime
        NyaaProvider(),  # Anime
        AnimeToshoProvider(),  # Anime
        TokyoToshokanProvider(),  # Anime
        
        # TV Series
        EztvProvider(),  # TV Series
        
        # Porn (at the bottom)
        MyPornClubProvider(),  # Porn
        SukebeiProvider(),  # Porn
        XXXClubProvider(),  # Porn
    ]
